﻿using Livet;

namespace Azyobuzi.Twikoto2.Models
{
    public class Query : NotifyObject
    {
        /*
         * NotifyObjectはプロパティ変更通知の仕組みを実装したオブジェクトです。
         */

        /*
         * リッチクライアントはステートフルであるため、通常のイベントの使用はメモリリークの原因になりやすくなっています。
         * Modelからイベントを発行する場合はNotificatorを使用してください。
         *
         * Notificatorはイベント代替手段です。コードスニペット lnev でCLRイベントと同時に定義できます。
         *
         * Model同士でNotificatorを使用した通知を行う場合はNotificatorHelper、
         * ViewModelへNotificatorを使用した通知を行う場合はViewModelHelperを使用して受信側の登録をしてください。
         */

        TimelineTypes _Type;

        public TimelineTypes Type
        {
            get
            { return _Type; }
            set
            {
                if (_Type == value)
                    return;
                _Type = value;
                RaisePropertyChanged("Type");
            }
        }

        string _Parameter = string.Empty;

        public string Parameter
        {
            get
            { return _Parameter; }
            set
            {
                if (_Parameter == value)
                    return;
                _Parameter = value;
                RaisePropertyChanged("Parameter");
            }
        }

        public override bool Equals(object obj)
        {
            var target = obj as Query;
            return target != null &&
                this.Type == target.Type &&
                this.Parameter == target.Parameter;
        }

        public override int GetHashCode()
        {
            return this.Type.GetHashCode() ^ this.Parameter.GetHashCode();
        }
    }
}
